local pn = ...;
assert(pn);

-- Makes difficulty for specified player.
local function Difficulty(pn)
	local diff = AutoText("frutiger",true)..{
		Name="Difficulty"..pn;
		InitCommand=cmd(zoom,0.6;shadowlength,1);
		OnCommand=cmd(playcommand,"Set");

		SetCommand=function(self)
			-- player check
			if not GAMESTATE:IsHumanPlayer(pn) then
				self:visible(false);
				return;
			end;

			-- song/course check
			local SongOrCourse = nil;
			local StepsOrTrail = nil;
			if GAMESTATE:IsCourseMode() then
				SongOrCourse = GAMESTATE:GetCurrentCourse();
				StepsOrTrail = GAMESTATE:GetCurrentTrail(pn);
			else
				SongOrCourse = GAMESTATE:GetCurrentSong();
				StepsOrTrail = GAMESTATE:GetCurrentSteps(pn);
			end;

			if SongOrCourse == nil or StepsOrTrail == nil then
				self:visible(false);
				return;
			end;

			if SongOrCourse then
				if StepsOrTrail then
					local difficulty = StepsOrTrail:GetDifficulty();
					local diffstring = ( string.sub(difficulty,12) );
					local meter = StepsOrTrail:GetMeter();

					self:diffuse( DifficultyColor(StepsOrTrail:GetDifficulty()) );
					self:NoStroke();
					self:shadowcolor( DifficultyDarkColor(StepsOrTrail:GetDifficulty()) );

					--local dcNormal = DifficultyColor(steps:GetDifficulty());
					--local dcDark = DifficultyDarkColor(steps:GetDifficulty());
					--self:DiffuseAndStroke(dcNormal,dcDark)

					if difficulty == 'Difficulty_Edit' then
						diffstring = StepsOrTrail:GetDescription();
						if diffstring == "" then
							diffstring = "(untitled)";
						end;
					end;

					self:settext(diffstring .." [".. meter .."]");
				else
					self:settext("");
				end;
			else
				self:settext("");
			end;

			-- if we make it down here, we can be visible
			self:visible(true);
		end;
		OffCommand=cmd(linear,0.2;diffusealpha,0);
		CurrentSongChangedMessageCommand=cmd(playcommand,"Set");

		CurrentStepsP1ChangedMessageCommand=function(self)
			if pn == PLAYER_1 then self:playcommand("Set"); end;
		end;
		CurrentTrailP1ChangedMessageCommand=function(self)
			if pn == PLAYER_1 then self:playcommand("Set"); end;
		end;
		CurrentStepsP2ChangedMessageCommand=function(self)
			if pn == PLAYER_2 then self:playcommand("Set"); end;
		end;
		CurrentTrailP2ChangedMessageCommand=function(self)
			if pn == PLAYER_2 then self:playcommand("Set"); end;
		end;
	};
	return diff;
end;

return Difficulty(pn);